/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import emulator.hardware.io.peripherals.iec.DriveStatus;
import emulator.hardware.io.peripherals.iec.FsDriverChannel;
import emulator.hardware.io.peripherals.iec.IecSimFsDriver;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FsDriverCmdChannel
implements FsDriverChannel {
    static Logger logger = LogManager.getLogger((String)FsDriverCmdChannel.class.getName());
    IecSimFsDriver driver = null;
    byte[] buffer = null;
    int pos;

    public FsDriverCmdChannel(IecSimFsDriver driver) {
        this.driver = driver;
    }

    @Override
    public void open(String name) {
        this.exec(name);
    }

    private void exec(String cmd) {
        logger.info("command \"" + cmd + "\" received on channel " + this);
        if (cmd.startsWith("UI")) {
            this.driver.getDriveStatus().setStatus(73, 0, 0);
        } else if (cmd.startsWith("CD")) {
            this.driver.changeDirectory(cmd.substring(2));
        } else {
            this.driver.getDriveStatus().setStatus(30, 0, 0);
        }
        this.setupStatus();
    }

    private void setupStatus() {
        DriveStatus drive_status = this.driver.getDriveStatus();
        this.buffer = drive_status.readStatus().getBytes();
        this.pos = 0;
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    @Override
    public void write(ByteBuffer data) {
    }

    @Override
    public int read() {
        if (this.buffer == null) {
            this.setupStatus();
        }
        if (this.pos < this.buffer.length) {
            int b;
            return (b = this.buffer[this.pos++]) < 0 ? b + 256 : b;
        }
        return -1;
    }

    @Override
    public void rewind(int offset) {
        this.pos -= offset;
        if (this.pos < 0) {
            this.pos = 0;
        }
    }
}

